// 変数
const headerElem = document.getElementsByTagName('header');
const spButton = document.getElementById("sp-menu");

// ロード後処理
window.addEventListener('DOMContentLoaded', function () {
    pageTop();
    linkJump();
});

// ページトップ
function pageTop() {
    const pagetop = document.getElementById('pagetop');
    if (pagetop) {
        pagetop.addEventListener('click', function () {
            smoothScroll(0);
        });
    }
}

// ページ内リンクジャンプ
function linkJump() {
    const spaceY = 150;
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            // スマホでメニューが開いていたら閉じる。
            if (spButton.classList.contains("open")) {
                spMenuClose();
            }

            e.preventDefault();
            const href = anchor.getAttribute('href');
            const target = document.getElementById(href.replace('#', ''));
            const targetPosition = target.getBoundingClientRect().top + window.scrollY - spaceY;
            smoothScroll(targetPosition);
        });
    });
}

// スムーススクロール
function smoothScroll(targetPos) {
    window.scrollTo({
        top: targetPos,
        behavior: 'smooth'
    });
}

// スマホメニュー開閉
spButton.addEventListener("click", function () {
    if (spButton.classList.contains("open")) {
        spMenuClose();
    } else {
        spButton.classList.add('open');
        headerElem[0].classList.add("open");
    }
})

// メニュー閉じる
function spMenuClose() {
    spButton.classList.remove('open');
    headerElem[0].classList.remove("open");
    headerElem[0].classList.add("close");
    headerElem[0].addEventListener("animationend", function () {
        headerElem[0].classList.remove("close");
    })
}