(function () {
  var root;
  var scripts = document.getElementsByTagName("script");
  var i = scripts.length;
  while (i--) {
    if(scripts[i].src.match(/(^|.*\/)particle\.js$/)){
      var src = scripts[i].getAttribute("src");
      root = src.replace("js/particle.js","");
      break;
    }
  }

  // 桜パーティクル
  particlesJS("particles-js", {
    "particles": {
      "number": {
        "value": 30, // 桜の数
        "density": {
          "enable": true,
          "value_area": 1121.6780303333778
        }
      },
      "color": {
        "value": "#fff"
      },
      "shape": {
        "type": "image", // 形状は画像を指定
        "stroke": {
          "width": 0,
        },
        "image": {
          "src": root+"images/flower.png", // 花びらの画像
          "width": 120,
          "height": 120
        }
      },
      "opacity": {
        "value": 0.06409588744762158,
        "random": true,
        "anim": {
          "enable": false,
          "speed": 1,
          "opacity_min": 0.1,
          "sync": false
        }
      },
      "size": {
        "value": 8.011985930952697,
        "random": true, // サイズをランダムに
        "anim": {
          "enable": false,
          "speed": 4,
          "size_min": 0.1,
          "sync": false
        }
      },
      "line_linked": {
        "enable": false,
      },
      "move": {
        "enable": true,
        "speed": 7, // 動きの速度
        "direction": "bottom-right", // 落ちる方向
        "random": false, // ランダム性
        "straight": false, // 動きをとどめない
        "out_mode": "out", // 画面の外に出るように描写
        "bounce": false, // 跳ね返りなし
        "attract": {
          "enable": false,
          "rotateX": 281.9177489524316,
          "rotateY": 127.670995809726
        }
      }
    },
    "interactivity": {
      "detect_on": "canvas",
      "events": {
        "onhover": {
          "enable": false,
        },
        "onclick": {
          "enable": false,
        },
        "resize": true
      }
    },
    "retina_detect": false
  });
})();
